function [Torque] = meshingTorque(pt, r2contact1, r2contact2, Rext, w)
%This function evaluates pressure torque on driven gear
%INPUT
% pt [Pa]: row vector containing pressure in Trapped Volume
% r2contact1, r2contact2 [mm] : radii connecting contact points 1 and 2 to
%                               driven gear center
% Rext [mm] : outer gear radius
% w  [mm] : gear thickness
%OUTPUT
%Troque [Nm] : resulting torque

%Global variables used in this function
global pm
global pa

w = w*0.001;                    %[mm] ---> [m]
Rext = Rext*0.001;              %[mm] ---> [m]
r2contact1 = r2contact1*0.001;  %[mm] ---> [m]
r2contact2 = r2contact2*0.001;  %[mm] ---> [m]

%Torque evaluation [Nm]
    if isnan(pt) == 1 %this formula applies to when trapped volume does not exist
        Torque = (pm - pa)*w*(Rext^2 - r2contact1^2)/2;
    else              %this formula applies to when trapped volume exists
        Torque =  (pm - pt)*w*(Rext^2 - r2contact1^2)/2 + ...
                      (pt - pa)*w*(Rext^2 - r2contact2^2)/2;
    end
end

